package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用池占用金额全量使用请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolOccupyToUseReqVo", description = "费用池占用金额全量使用请求VO")
public class FeePoolOccupyToUseReqVo {

    @ApiModelProperty("来源单号（必填）")
    private String fromCode;

    @ApiModelProperty("操作类型 枚举 FeePoolOperationTypeEnum 或者数据字典 fee_pool_operation_type 默认 6：订单使用")
    private String operationType;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("备注")
    private String remarks;
}