package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 费用池使用金额请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolUseReqVo", description = "费用池使用金额请求VO")
public class FeePoolUseReqVo {

    @ApiModelProperty("费用池分组，不填表示默认")
    private String poolGroup;

    @ApiModelProperty("客户编码（必填）")
    private String customerCode;

    @ApiModelProperty("操作类型（必填）")
    private String operationType;

    @ApiModelProperty("折扣使用")
    private FeePoolDiscountUseReqVo discount;

    @ApiModelProperty("货补费用")
    private FeePoolGoodsUseReqVo goods;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述（如果为空，则默认记录操作类型的中文描述）")
    private String fromDesc;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;
}