package com.biz.crm.nebular.fee.pool.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * 下拉框选项VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "下拉框选项VO")
public class FeePoolPageConfigVo {

    @ApiModelProperty("费用池分组下拉框")
    private List<FeeSelectOptionVo> poolGroupList = new ArrayList<>();

    @ApiModelProperty("费用池类型下拉框")
    private List<FeeSelectOptionVo> poolTypeList = new ArrayList<>();

    @ApiModelProperty("使用类型下拉框")
    private List<FeeSelectOptionVo> useTypeList = new ArrayList<>();

    @ApiModelProperty("列表查询操作类型下拉框")
    private List<FeeSelectOptionVo> queryOperationTypeList = new ArrayList<>();

    @ApiModelProperty("列表头上账操作类型下拉框")
    private List<FeeSelectOptionVo> accountOperationTypeList = new ArrayList<>();

    @ApiModelProperty("列表行调整操作类型下拉框")
    private List<FeeSelectOptionVo> adjustOperationTypeList = new ArrayList<>();

    @ApiModelProperty("列表行冻结操作类型下拉框")
    private List<FeeSelectOptionVo> freezeOperationTypeList = new ArrayList<>();

    @ApiModelProperty("列表行解冻操作类型下拉框")
    private List<FeeSelectOptionVo> unfreezeOperationTypeList = new ArrayList<>();

    @ApiModelProperty("行调整页面配置编码")
    private String lineDetailAdjustConfigCode;

}