package com.biz.crm.nebular.kms.acceptanceform.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 转换后验收单请求vo
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsAcceptanceFormReqVo", description = "转换后验收单")
public class KmsAcceptanceFormReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 8796734038050633713L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("关联订货单（kms_order_form_detail_dw：orderNumber）")
    private String relateOrderNumber;

    @ApiModelProperty("关联原始订货单（kms_order_form_detail_dw：kaOrderNumber）")
    private String relateKaOrderNumber;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("抓单生成的验收单编号")
    private String orderNumber;

    @ApiModelProperty("商超验收单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("验收单当前状态 枚举：kms_order_status")
    private String orderStatus;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @ApiModelProperty("关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("验收日期")
    private String acceptanceDate;

    @ApiModelProperty("稽核日期")
    private String auditDate;

    @ApiModelProperty("单据日期开始时间")
    private String acceptanceDateStart;

    @ApiModelProperty("单据日期结束时间")
    private String acceptanceDateEnd;

    @ApiModelProperty("验收类型")
    private String acceptanceType;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("验收单总金额（含税）")
    private String finalAcceptanceAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @ApiModelProperty("验收单总金额（不含税）")
    private String finalAcceptanceAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品编码集合")
    private List<String> kaGoodsCodeList;
    /**
     * 匹配模版ID
     */
    @ApiModelProperty("稽核模版ID")
    private String auditTemplateId;

    @ApiModelProperty("商超ID集合")
    private List<String> directIds;

    @ApiModelProperty("稽核Id")
    private String auditId;

    @ApiModelProperty("稽核Id集合")
    private List<String> auditIds;

    @ApiModelProperty("已匹配验收单ids")
    private List<String> matchIds;

    @ApiModelProperty("sap明细项数量集合")
    private List<BigDecimal> quantityArray;

    @ApiModelProperty("公司组织编码")
    private String companyOrgCode;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodes;
}