package com.biz.crm.nebular.kms.confadmin.base;

import com.google.common.base.Enums;
import lombok.Getter;

/**
 * <p>
 * 定制字段类别常量
 * <p>
 *
 * @author Byran
 * @since 2019-08-30
 **/
public class BaseClassifyConstants {

    /**
     * 控件类型
     */
    @Getter
    public enum FieldClassify {
        /**
         * 单行文本
         */
        INPUT("INPUT", "单行文本"),
        /**
         * 多行文本
         */
        TEXT("TEXT", "多行文本"),
        /**
         * 单选下拉
         */
        SELECT("SELECT", "单选下拉"),
        /**
         * 下拉多选
         */
        CHECKBOX("CHECKBOX", "下拉多选"),
        /**
         * 数字
         */
        NUMBER("NUMBER", "数字"),
        /**
         * 货币
         */
        MONEY("MONEY", "货币"),
        /**
         * 电话
         */
        PHONE("PHONE", "电话"),
        /**
         * 邮箱
         */
        MAILBOX("MAILBOX", "邮箱"),
        /**
         * 日期（例：2019-08-28）
         */
        DATE("DATE", "日期"),
        /**
         * 日期时间（例：2019-08-28 00:00:00）
         */
        DATETIME("DATETIME", "日期时间"),
        /**
         * 附件
         */
        FILE("FILE", "附件"),
        /**
         * 查询时间
         */
        CREATE_DATE("CREATE_DATE", "创建时间"),
        /**
         * 日期范围（例：2019-08-28 ～ 2019-09-01）
         */
        DATERANGE("DATERANGE", "日期范围"),
        /**
         * 日期时间范围（例：2019-08-28 00:00:00 ～ 2019-09-01 00:00:00）
         */
        DATETIMERANGE("DATETIMERANGE", "创建时间"),
        /**
         * 周（例：2019年第32周）
         */
        WEEKLY("WEEKLY", "周"),
        /**
         * 单选树状结构
         */
        SINGLE_TREE_SELECT("SINGLE_TREE_SELECT", "单选树状结构"),
        /**
         * 多选树状结构
         */
        MULTI_TREE_SELECT("MULTI_TREE_SELECT", "多选树状结构"),
        ;


        private String value;
        private String description;

        FieldClassify(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static BaseClassifyConstants.FieldClassify getIfPresent(String name) {
            return Enums.getIfPresent(BaseClassifyConstants.FieldClassify.class, name).orNull();
        }
    }

    /**
     * 模块定制字段
     */
    public enum ModuleClassify {
        /**
         * 未指定（用于不存在模块的地方）
         */
        MODULE_UNSPECIFIED("-1", "未指定"),
        /**
         * 单据模块
         */
        MODULE_ORDER("0", "单据模块"),
        /**
         * 商超门店
         */
        MODULE_BUSINESS_SUPER_STORES("4", "商超门店"),
        /**
         * 操作日志
         */
        MODULE_OPERATION_LOG("5", "操作日志"),
        /**
         * 数据日志
         */
        MODULE_DATA_LOG("6", "数据日志"),
        /**
         * 上架产品
         */
        MODULE_ON_SHELF_PRODUCT("6", "数据上架产品日志"),
        /**
         * 子模块-订货单
         */
        SUB_MODULE_ORDER("01", "子模块-订货单"),
        SUB_MODULE_ACCEPTANCE("02", "子模块-验收单"),
        SUB_MODULE_RETURN("03", "子模块-退货单"),
        SUB_MODULE_PRICE("04", "子模块-变价单"),
        SUB_MODULE_SALES_DATA("05", "子模块-销售数据"),
        SUB_MODULE_INVENTORY_DATA("06", "子模块-库存数据"),
        SUB_MODULE_BILLING_DATA("07", "子模块-结算数据"),
        SUB_MODULE_FEE_DATA("08", "子模块-费用数据"),
        /**
         * 产品模块
         */
        MODULE_PRODUCT("1", "产品模块"),
        SUB_MODULE_PRODUCT("11", "子模块-产品"),
        /**
         * （产品）产品信息子模块
         MODULE_ON_SHELF_PRODUCT
        MODULE_PRODUCT_INFO("31", "产品信息"),
        /**
         * （产品）库存信息子模块
         */
        MODULE_PRODUCT_STOCK("32", "库存信息"),
        /**
         * （产品）价格信息子模块
         */
        MODULE_PRODUCT_PRICE("33", "价格信息"),
        /**
         * （产品）备注信息子模块
         */
        MODULE_PRODUCT_REMARKS("34", "备注信息"),


        /**
         * 用户管理模块
         */
        MODULE_USER("2", "用户管理模块"),
        SUB_MODULE_USER("21", "用户"),
        SUB_MODULE_ORG("22", "组织"),

        /**
         * 进销存模块
         */
        MODULE_PURCHASE_ORDER("1","采购订单"),
        MODULE_PURCHASE_STORAGE("2","采购入库单"),
        MODULE_PURCHASE_REFUND("3","采购退货单");

        private String value;
        private String description;

        ModuleClassify(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }

    /**
     * 字段分类
     */
    public enum FieldCategory {
        /**
         * 单据
         */
        INVOICE(0, "单据"),
        /**
         * 商品
         */
        GOODS(1, "商品"),

        /**
         * 产品
         */
        PRODUCT(2, "产品"),
        /**
         * 上架产品
         */
        ON_SHELF_PRODUCT(3,"上架产品"),
        /**
         * 商超门店
         */
        BUSINESS_SUPER_STORES(4,"商超门店"),
        /**
         * 用户
         */
        USER(5,"用户"),
        /**
         * 结算主体
         */
        SETTLE_SUBJECT(6,"结算主体"),
        /**
         * 操作日志
         */
        OPERATION_LOG(7,"操作日志"),
        /**
         * 数据日志
         */
        DATA_LOG(8,"数据日志"),
        /**
         * 售达方
         */
        SELL_PARTY(9,"售达方"),
        /**
         * 销售报表
         */
        SALE_REPORT(10,"销售报表"),
        /**
         * 订单报表
         */
        ORDER_REPORT(11,"订单报表"),
        /**
         * 库存报表
         */
        STOCK_REPORT(12,"库存报表"),
        /**
         * 百威销售报表
         */
        BW_SALE_REPORT(13,"百威销售报表"),
        /**
         * 百威库存报表
         */
        BW_STOCK_REPORT(14,"百威库存报表"),
        /**
         * 订单管理
         */
        /**
         * 应付明细
         */
        PAYABLE(16,"应付明细"),
        /**
         * 应收明细
         */
        RECEIVABLE(17,"应收明细"),
        ORDER_MANAGEMENT(18,"订单管理"),
        GRAB_RULE_REPORT(19,"抓单规则执行报表"),
        STOCK_DISTRIBUTE_REPORT(20,"库存分布报表"),
        SALE_IN_STOCK_REPORT(21,"客户进销存报表"),
        ORDER_ACCOUNT_STOCK_REPORT(22,"订单台账报表"),
        STORE_ORDER_ANALYSIS_STOCK_REPORT(23,"门店订货统计报表"),
        ;

        private Integer value;
        private String description;

        FieldCategory(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }

    /**
     * 分组类型
     */
    public enum GroupCategory {
        /**
         * 直营体系分组
         */
        DIRECT(0, "直营体系分组"),

        /**
         * 跨域分组
         */
        CROSS(1, "跨域分组");

        private Integer value;
        private String description;

        GroupCategory(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }

    /**
     * 表格类型
     */
    public enum Kind {
        /**
         * 抓取
         */
        GRAB(0, "抓取"),

        /**
         * 导入或手动添加
         */
        IMPORT(1, "导入或手动添加");

        private Integer value;
        private String description;

        Kind(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }

    /**
     * 参数类型
     */
    @Getter
    public enum ParamClassify {
        /**
         * 商超系统
         */
        DIRECT(0, "商超系统"),

        /**
         * 新增参数
         */
        ADD(1, "新增参数");

        private Integer value;
        private String description;

        ParamClassify(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public static BaseClassifyConstants.ParamClassify getIfPresent(String name) {
            return Enums.getIfPresent(BaseClassifyConstants.ParamClassify.class, name).orNull();
        }
    }

    /**
     * 编辑单据
     */
    public static final String EDIT = "EDIT";

    /**
     * 拆分单据
     */
    public static final String SPLIT = "SPLIT";

    /**
     * 订货单
     */
    public static final String ORDER_FORM_TABLE = "kms_order_form_detail_dw";
    public static final String ORDER_GOODS_TABLE = "kms_order_goods_detail_dw";
    /**
     * 验收单
     */
    public static final String ACCEPTANCE_FORM_TABLE = "kms_acceptance_form_detail_dw";
    public static final String ACCEPTANCE_GOODS_TABLE = "kms_acceptance_goods_detail_dw";
    /**
     * 销售数据
     */
    public static final String SALE_FORM_TABLE = "kms_sale_data_form_detail_dw";
    /**
     * 库存数据
     */
    public static final String INVENTORY_FORM_TABLE = "kms_inventory_data_form_detail_dw";
    /**
     * 费用数据
     */
    public static final String FEE_FORM_TABLE = "kms_fee_data_form_detail_dw";
    /**
     * 结算数据
     */
    public static final String BILLING_FORM_TABLE = "kms_billing_data_form_detail_dw";
    public static final String BILLING_PAYABLE_GOODS_TABLE = "kms_billing_data_payable_goods_detail_dw";
    public static final String BILLING_RECEIVABLE_GOODS_TABLE = "kms_billing_data_receivable_goods_detail_dw";
    /**
     * 退货单
     */
    public static final String RETURN_FORM_TABLE = "kms_return_form_detail_dw";
    public static final String RETURN_GOODS_TABLE = "kms_return_goods_detail_dw";
    /**
     * 变价单
     */
    public static final String PRICE_FORM_TABLE = "kms_price_form_detail_dw";
    public static final String PRICE_GOODS_TABLE = "kms_price_goods_detail_dw";

}
