package com.biz.crm.nebular.kms.confadmin.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商超支持抓取单据类型信息请求vo
 *
 * @author Gavin
 * @date 2021-05-06 16:54:55
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsDirectOrderTypeReqVo", description = "商超支持抓取单据类型信息")
public class KmsDirectOrderTypeReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -8548560597037122229L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("单据类型名称")
    private String orderTypeName;

    @ApiModelProperty("单据下载方式")
    private Integer orderDownloadWay;

    @ApiModelProperty("原始文件格式")
    private Integer fileClassify;

    @ApiModelProperty("文件下载方式")
    private Integer fileDownloadWay;
}