package com.biz.crm.nebular.kms.confadmin.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商超信息返回vo
 *
 * @author Gavin
 * @date 2021-05-06 13:51:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超信息")
public class KmsDirectSystemRespVo extends CrmExtTenVo {

    private static final long serialVersionUID = 6013711495505908123L;
    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("商超url地址")
    private String vendorSystemUrl;

    @ApiModelProperty("商超支持抓取单据类型信息")
    private List<KmsDirectOrderTypeRespVo> orderTypeVos;

    @ApiModelProperty("商超支持抓取单据类型信息列表使用")
    private String orderTypeStr;

    @ApiModelProperty("门店数量")
    private Integer storeAmount;
}