package com.biz.crm.nebular.kms.finance.resp;

import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 稽核数据返回vo
 *
 * @author Gavin
 * @date 2021-05-27 11:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "稽核数据")
public class KmsAuditFormRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -2545156688504073803L;

    @ApiModelProperty("汇总ID集合")
    private String idArray;

    @ApiModelProperty("稽核单号")
    private String auditNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("公司代码")
    private String bukrs;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;


    /**
     * 直营体系编码
     */
    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("验收日期")
    private String acceptanceDate;

    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("匹配结果（待匹配/无差异/有差异）")
    private String auditResult;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDate;

    @ApiModelProperty("sap过账日期导出")
    private String sapPostingDateExport;

    @ApiModelProperty("送达方编号")
    private String storeCode;

    @ApiModelProperty("送达方名称")
    private String storeName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("SAP物料号")
    private String sapMaterielCode;

    @ApiModelProperty("SAP物料名称")
    private String sapMaterielName;

    @ApiModelProperty("SAP数量")
    private BigDecimal sapQuantity;

    @ApiModelProperty("验收数量")
    private BigDecimal acceptanceQuantity;

    @ApiModelProperty("数量差异")
    private BigDecimal compareQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private BigDecimal sapAmountNot;

    @ApiModelProperty("验收金额（不含税）")
    private BigDecimal acceptanceAmountNot;

    @ApiModelProperty("金额差异（不含税）")
    private BigDecimal compareAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private BigDecimal sapAmount;

    @ApiModelProperty("验收金额（含税）")
    private BigDecimal acceptanceAmount;

    @ApiModelProperty("金额差异（含税）")
    private BigDecimal compareAmount;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("配送商")
    private String distributor;

    @ApiModelProperty("完成日期")
    private String completionDate;

    @ApiModelProperty("完成人")
    private String rinisher;

    @ApiModelProperty("稽核模版ID")
    private String auditTemplateId;

    @ApiModelProperty("容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    @ApiModelProperty("价格允差")
    private BigDecimal differencePrice;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("稽核状态(待确认/已确认)")
    private String auditStatus;

    /**
     * 是否稽核
     */
    @ApiModelProperty("是否稽核yes/no")
    private String isAudit;

    @ApiModelProperty("含税单价")
    private BigDecimal danjia;

    @ApiModelProperty("验收单含税单价")
    private BigDecimal acceptanceDanJia;

    @ApiModelProperty("SAP数据列表")
    private List<KmsSapOrderFormRespVo> sapOrderFormVos;

    @ApiModelProperty("验收单列表")
    private List<KmsAuditAcceptanceFormRespVo> acceptanceFormVos;
}