package com.biz.crm.nebular.kms.grabrule.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 单据抓取日志请求vo
 *
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsLoggerDataProcessReqVo", description = "单据抓取日志")
public class KmsLoggerDataProcessReqVo extends CrmExtTenVo {
    private static final long serialVersionUID = -2702657489201065070L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("直营体系ID")
    private String bsDirectSystemId;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("商超网址")
    private String vendorSystemUrl;

    @ApiModelProperty("登录账号")
    private String loginAcc;

    @ApiModelProperty("单据类型名称")
    private String orderTypeName;

    @ApiModelProperty("抓单规则名称")
    private String ruleName;

    @ApiModelProperty("抓单方式（自动抓单，手动抓单）")
    private String style;

    @ApiModelProperty("操作用户")
    private String nickName;

    @ApiModelProperty("抓取状态（0:成功，1：失败）")
    private Integer grabState;

    @ApiModelProperty("抓取结果")
    private String grabMessage;

    @ApiModelProperty("抓单日志")
    private String resultStr;

    @ApiModelProperty("开始时间")
    private String createDateAllStart;

    @ApiModelProperty("结束时间")
    private String createDateAllEnd;
}
