package com.biz.crm.nebular.kms.kaproduct.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 企业产品与商超产品单位转换关系表请求vo
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsProductUnitReqVo", description = "企业产品与商超产品单位转换关系表")
public class KmsProductUnitReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 4238202550041856499L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("企业产品与商超产品关系ID")
    private String tenantryDirectProductId;

    @ApiModelProperty("企业产品与商超产品关系ID集合")
    private List<String> tenantryDirectProductIds;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("企业产品单位编码")
    private String unitCode;

    @ApiModelProperty("企业产品单位名称")
    private String unitName;

    @ApiModelProperty("商超产品单位名称")
    private String kaUnitCode;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;
}