package com.biz.crm.nebular.kms.kaproduct.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author maoshen
 * @date 2021/7/5.
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "上架产品导出列表vo")
@CrmColumnResolve
public class KmsProductForExportRespVo extends KmsTenantryDirectProductRespVo {

    @ApiModelProperty("企业产品与商超产品关系ID")
    private String tenantryDirectProductId;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("企业产品单位编码")
    private String unitCode;

    @ApiModelProperty("企业产品单位名称")
    private String unitName;

    @ApiModelProperty("商超产品单位名称")
    private String kaUnitCode;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;

}
