package com.biz.crm.nebular.kms.kaproduct.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 企业产品与商超产品单位转换关系表返回vo
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "企业产品与商超产品单位转换关系表")
public class KmsProductUnitRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -8748986334606924758L;
    @ApiModelProperty("企业产品与商超产品关系ID")
    private String tenantryDirectProductId;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("企业产品单位编码")
    private String unitCode;

    @ApiModelProperty("企业产品单位名称")
    private String unitName;

    @ApiModelProperty("商超产品单位名称")
    private String kaUnitCode;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;
}