package com.biz.crm.nebular.kms.orderform.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商超订货单商品表请求vo
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsOrderGoodsReqVo", description = "商超订货单商品表")
public class KmsOrderGoodsReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 7048050388072430122L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("抓单生成的订单编号")
    private String orderNumber;

    @ApiModelProperty("抓单生成的订单编号集合")
    private List<String> orderNumberList;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据当前状态")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    @ApiModelProperty("关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("订货单价（含税）")
    private String unitPrice;

    @ApiModelProperty("订货金额小计（含税）")
    private String orderAmount;

    @ApiModelProperty("订货单价（不含税）")
    private String unitPriceNot;

    @ApiModelProperty("订货金额小计（不含税）")
    private String orderAmountNot;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("当前单位订货数量")
    private String curUnitOrderQuantity;

    @ApiModelProperty("最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("最小单位订货数量")
    private String minUnitOrderQuantity;

    @ApiModelProperty("最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最大单位订货数量")
    private String maxUnitOrderQuantity;

    @ApiModelProperty("工厂编码")
    private String factoryCode;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("产品税率")
    private String proRate;

    @ApiModelProperty("折扣")
    private String proRebate;

    @ApiModelProperty("详情来源")
    private String dataFrom;

    @ApiModelProperty("维护单价")
    private String orderPrice;

    @ApiModelProperty("单价差异")
    private String priceDiff;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("行信息排序")
    private Integer itemIndex;

    @ApiModelProperty("sap行项目号")
    private String sapItemNo;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;
}