package com.biz.crm.nebular.kms.rawdata.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 原单订单行数据信息请求vo
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsReturnGoodsDetailDwReqVo", description = "原单订单行数据信息")
public class KmsReturnGoodsDetailDwReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 8657727934559611880L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的退货单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超退货单编号")
    private String kaOrderNumber;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("退货单价（含税）")
    private String unitPrice;

    @ApiModelProperty("退货金额小计（含税）")
    private String returnAmount;

    @ApiModelProperty("退货单价（不含税）")
    private String unitPriceNot;

    @ApiModelProperty("退货金额小计（不含税）")
    private String returnAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("当前单位订货数量")
    private String curUnitOrderQuantity;

    @ApiModelProperty("最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("最小单位订货数量")
    private String minUnitOrderQuantity;

    @ApiModelProperty("最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最大单位订货数量")
    private String maxUnitOrderQuantity;

    @ApiModelProperty("商超名称")
    private String kaName;

}