package com.biz.crm.nebular.kms.rawdata.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 库存商超原始单据返回vo
 *
 * @author gavin
 * @date 2021-11-24 14:17:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "库存商超原始单据")
public class KmsSaleDataFormDetailDwRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 872610567408788466L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("企业销售数据编号")
    private String orderNumber;

    @ApiModelProperty("版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超单据编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("销售日期")
    private String salesDate;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("销售成本")
    private String salesCost;

    @ApiModelProperty("销售金额")
    private String salesAmount;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("字段转换标识：0未转换，1已转换")
    private String transStatus;

    @ApiModelProperty("门店所属大区编号")
    private String areaCode;

    @ApiModelProperty("门店所属大区名称")
    private String areaName;

    @ApiModelProperty("竞品品牌")
    private String competitiveBrands;

    @ApiModelProperty("当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("当前单位销售数量")
    private String curUnitSalesQuantity;

    @ApiModelProperty("最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("最小单位销售数量")
    private String minUnitSalesQuantity;

    @ApiModelProperty("最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最大单位销售数量")
    private String maxUnitSalesQuantity;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("登录账号")
    private String userName;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;
}