package com.biz.crm.nebular.kms.sap.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * SAP发票信息请求vo
 *
 * @author gavin
 * @date 2021-07-09 09:55:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsSapInvoiceReqVo", description = "SAP发票信息")
public class KmsSapInvoiceReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 1962375529433345455L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("出具发票日期")
    private String fkdat;

    @ApiModelProperty("创建时间")
    private String erzet;

    @ApiModelProperty("开票类型")
    private String fkart;

    @ApiModelProperty("开票类型中文描述")
    private String fkartvtext;

    @ApiModelProperty("发票号")
    private String vbeln;

    @ApiModelProperty("行项目")
    private String posnr;

    @ApiModelProperty("行项目类别")
    private String pstyv;

    @ApiModelProperty("行项目类别中文描述")
    private String vtext;

    @ApiModelProperty("交货单号")
    private String vgbel;

    @ApiModelProperty("交货单行项目")
    private String vgpos;

    @ApiModelProperty("订单号")
    private String aubel;

    @ApiModelProperty("订单号行项目")
    private String aupos;

    @ApiModelProperty("公司代码")
    private String bukrs;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("物料编码")
    private String matnr;

    @ApiModelProperty("物料描述")
    private String maktx;

    @ApiModelProperty("物料类型")
    private String mtpos;

    @ApiModelProperty("发票数量")
    private BigDecimal fkimg;

    @ApiModelProperty("发票数量赠品不显示")
    private BigDecimal fkimgzp;

    @ApiModelProperty("销售单位")
    private String vrkme;

    @ApiModelProperty("销售单位中文描述")
    private String vrkmename;

    @ApiModelProperty("价格单位发票数量")
    private BigDecimal fkimg1;

    @ApiModelProperty("价格单位发票数量赠品不显示")
    private BigDecimal fkimgzp1;

    @ApiModelProperty("价格单位")
    private String kmein;

    @ApiModelProperty("价格单位中文描述")
    private String kmeinname;

    @ApiModelProperty("发票净值")
    private BigDecimal netwr;

    @ApiModelProperty("发票税额")
    private BigDecimal mwsbp;

    @ApiModelProperty("含税总价")
    private BigDecimal kzwi1;

    @ApiModelProperty("税率")
    private BigDecimal mwsi1;

    @ApiModelProperty("返利")
    private BigDecimal kzwi4;

    @ApiModelProperty("折扣")
    private BigDecimal yk99;

    @ApiModelProperty("送达方编码")
    private String kunnr;

    @ApiModelProperty("送达方名称")
    private String kunnrname;

    @ApiModelProperty("售达方编码")
    private String kunag;

    @ApiModelProperty("售达方名称")
    private String kunagname;

    @ApiModelProperty("物料单位分类")
    private String vrkmetype;

    @ApiModelProperty("物料规格")
    private String guige;

    @ApiModelProperty("分销渠道")
    private String vtweg;

    @ApiModelProperty("订单创建日期")
    private String vbakerdat;

    @ApiModelProperty("配送商编码")
    private String lifnr;

    @ApiModelProperty("配送商名称")
    private String name3;

    @ApiModelProperty("商超订单编号")
    private String bstkd;

    @ApiModelProperty("产品含税单价")
    private BigDecimal danjia;

    @ApiModelProperty("物料数量价格折扣 (PR)")
    private BigDecimal yk04;

    @ApiModelProperty("即时返点%产品组折扣(PR)")
    private BigDecimal yk11;

    @ApiModelProperty("赠品分摊折扣")
    private BigDecimal zst2;

    @ApiModelProperty("业务员编码")
    private String pernr;

    @ApiModelProperty("业务员描述")
    private String name4;
}