package com.biz.crm.nebular.kms.sap.req;

import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * SAP数据请求vo
 *
 * @author Gavin
 * @date 2021-05-27 14:34:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsSapOrderFormReqVo", description = "SAP数据")
public class KmsSapOrderFormReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -4612368645331118509L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("sap单据编码")
    private String sapNo;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDate;

    @ApiModelProperty("送达方编号")
    private String storeCode;

    @ApiModelProperty("送达方编号集合")
    private List<String> storeCodeList;

    @ApiModelProperty("售达方编号集合")
    private List<String> soldToPartyCodeList;

    @ApiModelProperty("送达方名称")
    private String storeName;

    @ApiModelProperty("SAP物料号")
    private String sapMaterielCode;

    @ApiModelProperty("SAP物料名称")
    private String sapMaterielName;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("SAP数量")
    private String sapQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private String sapAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private String sapAmount;

    @ApiModelProperty("配送商")
    private String distributor;

    @ApiModelProperty("匹配模版ID集合(用于判断当前规则是否汇总当前数据)")
    private String auditTemplateId;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营门店ID")
    private String storeId;

    @ApiModelProperty("抓取SAP数据直营门店")
    private String selectedCode;

    @ApiModelProperty("发票类型集合")
    private List<String> invoiceTypeList;

    @ApiModelProperty("公司代码集合")
    private List<String> companyCodeList;

    @ApiModelProperty("SAP发票创建时间")
    private String invoiceCreateTime;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("SAP数据ID集合")
    private List<String> invoiceIds;

    @ApiModelProperty("模版信息")
    private List<KmsAuditTemplateRespVo> auditTemplateVo;
}