package com.biz.crm.nebular.kms.supermarket.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Collection;
import java.util.List;

/**
 * 客户组织与抓单商超（直营体系）关系表请求vo
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsTenantryDirectCustomerOrgReqVo", description = "客户组织与抓单商超（直营体系）关系表")
public class KmsTenantryDirectCustomerOrgReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -12185615360784942L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系编码集合")
    private Collection<String> bsDirectSystemCodeList;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("客户组织ID")
    private String customerOrgId;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("订单推送SAP时间计算阈值")
    private Integer timeOfDay;

    @ApiModelProperty("商超IDList")
    private List<String> directIdList;

    @ApiModelProperty("公司组织编码")
    private String companyOrgCode;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodes;
}