package com.biz.crm.nebular.kms.supermarket.req;

import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 总仓门店请求vo
 *
 * @author lf
 * @date 2021-06-26 11:20:06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsTotalWarehouseStoreReqVo", description = "总仓门店")
public class KmsTotalWarehouseStoreReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 6352361829692414582L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("产品类型-数据字典：kms_product_type")
    private String productType;

    @ApiModelProperty("产品类型描述")
    private String productTypeDesc;

    @ApiModelProperty("直营门店ID")
    private String directStoreId;

    @ApiModelProperty("送达方编码-取企业门店编码")
    private String terminalCode;

    @ApiModelProperty("送达方名称-取企业门店名称")
    private String terminalName;

    @ApiModelProperty("上架产品")
    private List<KmsTenantryDirectProductReqVo> directProductReqVos;

    @ApiModelProperty("企业商品编码")
    private String productCode;

    @ApiModelProperty
    private String productName;

    @ApiModelProperty("直营体系id集合")
    private List<String> bsDirectSystemIdList;

    @ApiModelProperty("直营体系Code集合")
    private List<String> bsDirectSystemCodeList;

    @ApiModelProperty("送达方编码集合")
    private List<String> terminalCodeList;

    @ApiModelProperty("产品id集合")
    private List<String> productIds;
}