package com.biz.crm.nebular.mdm.availablelist;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/13 11:24
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户可够清单的vo")
@SaturnEntity(name = "CusAvailablelistVo", description = "客户可够清单信息")
public class CusAvailablelistVo extends MdmProductAdviseRespVo {

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户所属组织编码")
    @SaturnColumn(description = "客户所属组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户所属组织名称")
    @SaturnColumn(description = "客户所属组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "客户所属渠道编码")
    @SaturnColumn(description = "客户所属渠道编码")
    private String cusChannelCode;

    @ApiModelProperty(value = "客户所属渠道名称")
    @SaturnColumn(description = "客户所属渠道名称")
    @CrmDict(typeCode = "channel", dictCodeField = "cusChannelCode")
    private String cusChannelName;

    @ApiModelProperty(value = "是否常购")
    @SaturnColumn(description = "是否常购")
    private Integer ofenFlag;

    @ApiModelProperty(value = "价格")
    @SaturnColumn(description = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "当前是否享受促销")
    @SaturnColumn(description = "当前是否享受促销")
    private Integer promotionFlag;
    /**
     * 客户信息(拓展用)
     */
    private MdmCustomerMsgRespVo cus;
}
