package com.biz.crm.nebular.mdm.constant;

public enum PositionOperationEnum {

    NEW("n", "新建职位"),
    HISTORY("h", "已有职位"),
    ;

    PositionOperationEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;

    public static PositionOperationEnum getEnumByCode(String code) {
        if (code != null) {
            for (PositionOperationEnum item :
                    PositionOperationEnum.values()) {
                if (item.getCode().equals(code)) {
                    return item;
                }
            }
        }
        return null;
    }

    public static boolean exist(String code) {
        if (code != null) {
            for (PositionOperationEnum item :
                    PositionOperationEnum.values()) {
                if (item.getCode().equals(code)) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
