package com.biz.crm.nebular.mdm.cusorg;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;


/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 11:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户组织的vo")
@SaturnDomain(value = "cusorgvo")
@SaturnEntity(name = "CusOrgVo", description = "客户组织")
@CrmColumnResolve
public class CusOrgVo extends CrmTreeVo {

    private static final long serialVersionUID = -7547369159738273238L;
    @ApiModelProperty("公共树编码")
    private String code;

    @ApiModelProperty("id集合")
    private List<String> ids;

    @ApiModelProperty(value = "客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    @SaturnColumn(description = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty(value = "客户组织层级")
    @SaturnColumn(description = "客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty(value = "客户组织层级名称")
    @SaturnColumn(description = "客户组织层级名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_LEVEL,dictCodeField = "customerOrgLevel")
    private String customerOrgLevelName;

    @ApiModelProperty(value = "客户组织类型")
    @SaturnColumn(description = "客户组织类型")
    private String customerOrgType;

    @ApiModelProperty(value = "客户组织类型名称")
    @SaturnColumn(description = "客户组织类型名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_TYPE,dictCodeField = "customerOrgType")
    private String customerOrgTypeName;

    @ApiModelProperty(value = "客户组织描述")
    @SaturnColumn(description = "客户组织描述")
    private String customerOrgDesc;

    @ApiModelProperty("上级编码")
    private String parentCode;

    @ApiModelProperty(value = "上级组织名称")
    @SaturnColumn(description = "上级组织名称")
    private String parentName;

    @ApiModelProperty("编码或名称")
    @SaturnColumn(description = "编码或名称")
    private String codeOrgName;

    @ApiModelProperty("当前客户组织编码")
    @SaturnColumn(description = "当前客户组织编码")
    private String currentCustomerOrgCode;

}
