package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.config.CrmColumnResolve;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "客户销售报表")
@SaturnDomain(value = "customersalerespvo")
@SaturnEntity(name = "CustomerSaleRespVo", description = "客户销售报表")
@CrmColumnResolve
public class CustomerSaleRespVo {

    @ApiModelProperty("日期")
    private String createDate;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("所属组织名称,区域")
    @SaturnColumn(description = "所属组织名称")
    private String orgName;

    @ApiModelProperty(value = "当月订单金额汇总")
    private BigDecimal ordSum;

    @ApiModelProperty(value = "当月申请金额汇总")
    private BigDecimal actSum;

    @ApiModelProperty(value = "当月申请费率")
    private BigDecimal rate;

    @ApiModelProperty(value = "上月费用核销金额汇总")
    private BigDecimal adSum;

}
