package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 客户开票信息请求vo
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerBillReqVo", description = "客户开票信息")
public class MdmCustomerBillReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("开票单位")
    private String billCompany;

    @ApiModelProperty("税号")
    private String taxNumber;

    @ApiModelProperty("法人")
    private String legal;

    @ApiModelProperty("开户银行")
    private String depositBank;

    @ApiModelProperty("银行帐号")
    private String bankAccount;

    @ApiModelProperty("是否是默认开票信息，1是0否")
    private String billMain;

}