package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "客户信息对接人")
public class MdmCustomerDockingRespVo extends CrmExtVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("用户帐号")
    private String userName;

    @ApiModelProperty("用户名称")
    private String fullName;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("二批商")
    private String secondCustomerCode;

    @ApiModelProperty("销售公司编码")
    private String saleCompany;

    @ApiModelProperty("客户供货关系列表")
    private List<MdmCustomerSupplyDetailRespVo> mdmCustomerSupplyDetailVos;

}