package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户标签响应vo
 *
 * @author yangshan
 * @date 2021-3-4 11:44:19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerTagRespVo", description = "客户标签")
public class MdmCustomerTagRespVo extends CrmExtTenVo {

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /**
     * 标签类型
     */
    @ApiModelProperty("标签类型 0 不可删除 1 手动增删")
    private String tagType;

    /**
     * 标签描述
     */
    @ApiModelProperty("标签描述")
    private String tagDescription;
}