package com.biz.crm.nebular.mdm.employeedirectory;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 员工通讯录信息响应vo
 * @author yangshan
 * @date 2021-3-5 14:46:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmEmployeeDirectoryRespVo", description = "员工通讯录信息")
public class MdmEmployeeDirectoryRespVo extends CrmBaseVo{
    /**
     * userCode
     */
    @ApiModelProperty("userCode")
    private String userCode;

    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    private String employeeCode;

    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名")
    private String employeeName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String posCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String posName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String phone;

    /**
     * 姓氏首字母
     */
    @ApiModelProperty("姓氏首字母")
    private String firstNameInitials;
}
