package com.biz.crm.nebular.mdm.engineform.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 表单引擎模板的数据层描述返回vo
 *
 * @author jerry7
 * @date 2020-11-17 09:25:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "表单引擎模板的数据层描述")
@SaturnEntity(name = "EngineFormListTemplateRespVo", description = "表单引擎模板的数据层描述")
public class EngineFormListTemplateRespVo  {
    @ApiModelProperty("列表模板的唯一编号")
    @SaturnColumn(description = "列表模板的唯一编号")
    private String code;

    @ApiModelProperty("创建者信息")
    @SaturnColumn(description = "创建者信息")
    private String creator;

    @ApiModelProperty("列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的")
    @SaturnColumn(description = "列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的")
    private String cversion;

    @ApiModelProperty("数据源类型：1、服务源；2、数据视图。默认为2")
    @SaturnColumn(description = "数据源类型：1、服务源；2、数据视图。默认为2")
    private Integer dataSource;

    @ApiModelProperty("当前表单模板版本是否是当前表单模板的默认版本")
    @SaturnColumn(description = "当前表单模板版本是否是当前表单模板的默认版本")
    private Boolean defaultVersion;

    @ApiModelProperty("保存的列表模板布局文件文件名")
    @SaturnColumn(description = "保存的列表模板布局文件文件名")
    private String fileName;

    @ApiModelProperty("列表模板的修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @SaturnColumn(description = "列表模板的修改时间")
    private Date modifyTime;

    @ApiModelProperty("列表模板的中文说明")
    @SaturnColumn(description = "列表模板的中文说明")
    private String name;

    @ApiModelProperty("项目名不填写也行，毕竟目前来看只可能是一个项目")
    @SaturnColumn(description = "项目名不填写也行，毕竟目前来看只可能是一个项目")
    private String projectName;

    @ApiModelProperty("列表模板文件的相对目录")
    @SaturnColumn(description = "列表模板文件的相对目录")
    private String relativePath;

    @ApiModelProperty("列表模板状态，1：正常；0或者其它值：作废")
    @SaturnColumn(description = "列表模板状态，1：正常；0或者其它值：作废")
    private Integer tStatus;

}