package com.biz.crm.nebular.mdm.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户登录返回vo
 *
 * @author zxw
 * @date 2020-11-19 13:49
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户登录请求vo")
public class MdmLoginReqVo extends MdmLoginEncryptReqVo {

    @ApiModelProperty("登录帐号")
    private String userName;
    @ApiModelProperty("密码")
    private String password;
    @ApiModelProperty("电话")
    private String userPhone;
    @ApiModelProperty("邮箱")
    private String email;
    @ApiModelProperty("验证码")
    private String verificationCode;
    /***登录来源*/
    private String fromType;
    @Deprecated
    private String openId;
}
