package com.biz.crm.nebular.mdm.login;

import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalLoginVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户登录返回vo
 *
 * @author zxw
 * @date 2020-11-19 13:49
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户登录返回vo")
public class MdmLoginRespVo {

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;
    @ApiModelProperty("登录帐号")
    private String userName;
    @ApiModelProperty("用户类型")
    private String userType;
    @ApiModelProperty("真实姓名")
    private String fullName;
    @ApiModelProperty("职位编码")
    private String positionCode;
    @ApiModelProperty("职位名称")
    private String positionName;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("微信openId")
    private String openId;
    @ApiModelProperty("语言种类")
    private String language;
    @ApiModelProperty("客户编码")
    private String customerCode;
    @ApiModelProperty("客户名称")
    private String customerName;
    @ApiModelProperty("用户登录令牌")
    private String loginUserToken;
    @ApiModelProperty("需要强制重设密码 0/1")
    private String resetPassword = "0";
    @ApiModelProperty("小程序免密(openId)登录成功状态：1表示登录成功，0表示登录失败")
    private String appletOpenIdLoginSuccessFlag;
    @ApiModelProperty("上一次登录日志")
    private MdmUserLoginLogRespVo lastLoginLog;

    @ApiModelProperty("客户相关信息")
    private MdmCustomerMsgRespVo mdmCustomerMsgRespVo;

    @ApiModelProperty("提示修改密码信息")
    private String remandMessage;

    @ApiModelProperty("终端信息")
    private List<MdmTerminalLoginVo> terminalVoList;
}
