package com.biz.crm.nebular.mdm.materialGroup;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @ClassName: MdmMaterialGroupRespVo
 * @Author: yangfan
 * @Description: 物料组返回vo
 * @Date: 2021/8/19 11:18
 * @Version: 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "物料组返回VO")
@CrmColumnResolve
public class MdmMaterialGroupRespVo extends CrmExtVo {
  @ApiModelProperty("物料组编码")
  private String materialGroupCode;

  @ApiModelProperty("物料组名称")
  private String materialGroupName;

  @ApiModelProperty("物料组描述")
  private String description;

  @ApiModelProperty("物料数量")
  private Integer materialNum;

  @ApiModelProperty("物料信息")
  private List<MdmMaterialRespVo> materialList;

}
