package com.biz.crm.nebular.mdm.notice.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公告读取信息 返回vo
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "公告读取信息 ")
@SaturnEntity(name = "SfaNoticeReadRespVo", description = "公告读取信息 ")
public class MdmNoticeReadRespVo extends CrmBaseVo {
    @ApiModelProperty("读取人账号 读取人账号")
    @SaturnColumn(description = "读取人账号 读取人账号")
    private String userName;

    @ApiModelProperty("读取人岗位 读取人岗位")
    @SaturnColumn(description = "读取人岗位 读取人岗位")
    private String posCode;

    @ApiModelProperty("公告编码 公告编码")
    @SaturnColumn(description = "公告编码 公告编码")
    private String noticeCode;

    @ApiModelProperty("公告编码集合")
    @SaturnColumn(description = "公告编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> noticeCodes;

}