package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据权限返回vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户组织列表")
@SaturnEntity(name = "MdmDataPermissionCustomerOrgVo", description = "客户组织列表")
@CrmColumnResolve
public class MdmDataPermissionCustomerOrgVo {

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty("客户组织类型")
    private String customerOrgType;

    @ApiModelProperty("查询方式类型:0当前客户组织，1当前及下级客户组织")
    private String permissionSearchType;

    @ApiModelProperty("查询方式名称")
    @CrmDict(typeCode = DictConstant.PERMISSION_OBJ, dictCodeField = "permissionSearchType")
    private String permissionSearchTypeName;

}