package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenObjVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 数据权限返回vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据权限(新)")
@CrmColumnResolve
public class MdmDataPermissionDetailVo extends CrmExtVo {

//    @ApiModelProperty("角色编码")
//    private String roleCode;
//
//    @ApiModelProperty("列表配置编码")
//    private String listConfigCode;
//
//    @ApiModelProperty("菜单编码")
//    private String functionCode;

    @ApiModelProperty("权限对象编码")
    private String permissionObjCode;

    @ApiModelProperty("权限对象名称")
    @CrmDict(typeCode = DictConstant.PERMISSION_OBJ, dictCodeField = "permissionObjCode")
    private String permissionObjName;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    private String permissionResource;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    @CrmDict(typeCode = DictConstant.PERMISSION_RESOURCE, dictCodeField = "permissionResource")
    private String permissionResourceName;

    @ApiModelProperty("查询方式类型")
    private String permissionSearchType;

    @ApiModelProperty("查询方式名称")
    private String permissionSearchTypeName;

    @ApiModelProperty("固定值编码集合")
    private List<String> detailCodeList;

    @ApiModelProperty("固定值名称集合")
    private List<String> detailNameList;

}