package com.biz.crm.nebular.mdm.poi.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "高德poi")
public class MdmAmapPoiReqVo extends PageVo {

    @ApiModelProperty( "高德poi唯一ID")
    private String amapId;

    @ApiModelProperty( "父POI的ID 当前POI如果有父POI，则返回父POI的ID。可能为空")
    private String parentAmapId;

    @ApiModelProperty( "名称")
    private String poiName;

    @ApiModelProperty( "兴趣点类型 顺序为大类、中类、小类 例如：餐饮服务;中餐厅;特色/地方风味餐厅")
    private String typeName;

    @ApiModelProperty( "兴趣点类型编码 例如：050118")
    private String typeCode;

    @ApiModelProperty( "行业类型")
    private String bizType;

    @ApiModelProperty( "地址 东四环中路189号百盛北门")
    private String address;

    @ApiModelProperty( "经纬度 格式（维度,经度）")
    private String location;

    @ApiModelProperty( "经度")
    private String longitude;

    @ApiModelProperty( "维度")
    private String latitude;

    @ApiModelProperty( "离中心点距离 单位：米；仅在周边搜索的时候有值返回")
    private String distance;

    @ApiModelProperty( "POI的电话")
    private String tel;

    @ApiModelProperty( "邮编 extensions=all时返回")
    private String postCode;

    @ApiModelProperty( "POI的网址  extensions=all时返回")
    private String website;

    @ApiModelProperty("POI的电子邮箱  extensions=all时返回")
    private String email;

    @ApiModelProperty("POI所在省份编码  extensions=all时返回")
    private String amapProvinceCode;

    @ApiModelProperty("POI所在省份名称 若是直辖市的时候，此处直接显示市名，例如北京市")
    private String amapProvinceName;

    @ApiModelProperty("城市编码 extensions=all时返回")
    private String amapCityCode;

    @ApiModelProperty( "城市名 若是直辖市的时候，此处直接显示市名，例如北京市")
    private String amapCityName;

    @ApiModelProperty("区域编码 extensions=all时返回")
    private String amapDistrictCode;

    @ApiModelProperty("区域名称 区县级别的返回，例如朝阳区")
    private String amapDistrictName;

    @ApiModelProperty("CRM区县编码")
    private String regionCode;

    @ApiModelProperty( "POI的入口经纬度，格式（维度,经度）  extensions=all时返回，也可用作于POI的到达点；")
    private String entrLocation;

    @ApiModelProperty("POI的入口经度")
    private String entrLongitude;

    @ApiModelProperty( "POI的入口维度")
    private String entrLatitude;

    @ApiModelProperty("POI导航id extensions=all时返回")
    private String naviPoiid;

    @ApiModelProperty( "地理格ID extensions=all时返回")
    private String gridCode;

    @ApiModelProperty("别名  extensions=all时返回")
    private String alias;

    @ApiModelProperty("所在商圈  extensions=all时返回")
    private String businessArea;

    @ApiModelProperty("该POI的特色内容 主要出现在美食类POI中，代表特色菜 例如“烤鱼,麻辣香锅,老干妈回锅肉extensions=all时返回")
    private String tag;

    @ApiModelProperty("一张图片")
    private String poiPhoto;

}
