package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-11-23 15:33
 *  @version: V1.0
 *  @Description:
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "以当前登录人查询职位和人员信息请求vo")
public class MdmPositionCurrentUserReqVo extends CrmTreeTenVo {
    @ApiModelProperty("查询用户账号")
    private String userName;
    @ApiModelProperty("模糊查询用户账号或名字")
    private String userNameOrFullName;
    @ApiModelProperty("默认为true（true：当前登录人组织及其所有下级组织的人，false：只查下级组织的人）")
    private Boolean currentLoginOrg;
    @ApiModelProperty("排除这些用户登录名")
    private List<String> notInUserNameList;
    @ApiModelProperty("客户用户登录账号，查询这个账号关联的经销商关联的客户用户")
    private String underCustomerUserName;

}
