package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/7 13:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmProductAdviseAndPriceReqVo extends CrmExtTenVo {
    @ApiModelProperty("时间,精确年月日，格式yyyy-MM-dd")
    private String searchTime;
    @ApiModelProperty(value = "条件类型编码集合", notes = "商品价格查询时的必要字段")
    private List<String> conditionTypeCodeList;

    @ApiModelProperty(value = "客户编码", notes = "商品价格查询时的必要字段")
    private String customerCode;

    /**
     * 客户组织编码
     */
    private String orgCode;

    /**
     * 产品编码集合
     */
    private List<String> productCodes;

    /**
     * 初始化方法
     *
     * @param customerCode
     * @param orgCode
     * @param productCodes
     * @return
     */
    public static MdmProductAdviseAndPriceReqVo newInstanceForSalePrice(String customerCode, String orgCode, List<String> productCodes) {
        MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo = new MdmProductAdviseAndPriceReqVo();
        mdmProductAdviseAndPriceReqVo.setCustomerCode(customerCode);
        mdmProductAdviseAndPriceReqVo.setOrgCode(orgCode);
        mdmProductAdviseAndPriceReqVo.setProductCodes(productCodes);
        List<String> list = new ArrayList<>();
        list.add("sale_price");
        mdmProductAdviseAndPriceReqVo.setConditionTypeCodeList(list);
        return mdmProductAdviseAndPriceReqVo;
    }

    /**
     * 初始化方法
     *
     * @param customerCode
     * @param orgCode
     * @param productCodes
     * @return
     */
    public static MdmProductAdviseAndPriceReqVo newInstanceForSalePrice(String customerCode, String orgCode, String searchTime, List<String> productCodes) {
        MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo = new MdmProductAdviseAndPriceReqVo();
        mdmProductAdviseAndPriceReqVo.setCustomerCode(customerCode);
        mdmProductAdviseAndPriceReqVo.setOrgCode(orgCode);
        mdmProductAdviseAndPriceReqVo.setSearchTime(searchTime);
        mdmProductAdviseAndPriceReqVo.setProductCodes(productCodes);
        List<String> list = new ArrayList<>();
        list.add("sale_price");
        mdmProductAdviseAndPriceReqVo.setConditionTypeCodeList(list);
        return mdmProductAdviseAndPriceReqVo;
    }


}
