package com.biz.crm.nebular.mdm.product.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.mdm.nebular.product.resp
 * @ClassName MdmProductIntroductionVo
 * @Author HuangLong
 * @Date 2020/9/1 17:54
 * @Description 图文信息
 */
@Data
@ApiModel(value = "商品图文信息")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@SaturnEntity(name = "MdmProductRespVo", description = "图文信息")
public class MdmProductIntroductionVo implements Serializable {

    private static final long serialVersionUID = 3847192614890510120L;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "图片")
    private List<MdmProductMediaRespVo> pictureList;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "视频")
    private List<MdmProductMediaRespVo> videoList;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "富文本")
    private MdmProductIntroductionRespVo introductionVo;

    @SaturnColumn(description = "基本信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private MdmProductRespVo productRespVo;
}
