package com.biz.crm.nebular.mdm.tableconfig;

import com.biz.crm.config.CrmColumnResolve;
import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 字段配置个性设置返回vo
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "字段配置个性设置")
@CrmColumnResolve
public class MdmColumnConfigPersonalRespVo extends UuidVo {

    @ApiModelProperty("当前职位编码")
    private String positionCode;

    @ApiModelProperty("上级菜单编码")
    private String parentCode;

    @ApiModelProperty("功能菜单编码")
    private String functionCode;

    @ApiModelProperty("标签")
    private String title;

    @ApiModelProperty("属性")
    private String field;

    @ApiModelProperty("显示模式：1显示，0隐藏")
    private String visible;

    @ApiModelProperty("顺序")
    private String formOrder;

}