package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:消费用户新增编辑请求VO
 * @project：crm-core
 * @package：com.biz.crm.nebular.mdm.user.req
 * @author：longyu
 * @create：2020/12/29 13:47
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmConsumerEditReqVo", description = "消费用户新增编辑请求VO")
public class MdmConsumerEditReqVo extends CrmExtTenVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("用户头像")
    private String userHeadUrl;

    @ApiModelProperty("工号")
    private String jobCode;

    @ApiModelProperty("员工类型")
    private String employeeType;

    @ApiModelProperty("员工状态")
    private String employeeStatus;

    @ApiModelProperty("身份证号码")
    private String identityCardNumber;

    @ApiModelProperty("身份证地址")
    private String identityCardAddress;

    @ApiModelProperty("民族")
    private String nationality;

    @ApiModelProperty("现住址")
    private String currentAddress;

    @ApiModelProperty("政治面貌")
    private String politicalAffiliation;
}
