package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户用户-终端关联：分页请求
 *
 * @author Tao.Chen
 * @date 2021-04-21 10:21:12
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerUserRelTerminalPageReqVo", description = "客户用户-终端关联：分页请求")
public class MdmCustomerUserRelTerminalPageReqVo extends PageVo {

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;
    @ApiModelProperty("用户登录名")
    private String userName;
    @ApiModelProperty("用户类型集合")
    private List<String> userTypeList;
    @ApiModelProperty("高德地图ID")
    private String amapId;
    @ApiModelProperty("终端编码")
    private String terminalCode;
    @ApiModelProperty("终端名称")
    private String terminalName;
    @ApiModelProperty("终端类型")
    private String terminalType;
    @ApiModelProperty("所属组织编码")
    private String orgCode;
    @ApiModelProperty("所属组织名字")
    private String orgName;
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;
    @ApiModelProperty("客户组织名称")
    private String customerOrgName;
    @ApiModelProperty("渠道")
    private String channel;
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;
    @ApiModelProperty("终端地址")
    private String terminalAddress;
    @ApiModelProperty("省编码")
    private String provinceCode;
    @ApiModelProperty("市编码")
    private String cityCode;
    @ApiModelProperty("区编码")
    private String districtCode;
    @ApiModelProperty("省名称")
    private String provinceName;
    @ApiModelProperty("市名称")
    private String cityName;
    @ApiModelProperty("区名称")
    private String districtName;
    @ApiModelProperty("店招照片")
    private String shopImagePath;
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;
    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("客户分类")
    private String customerClassification;
    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;
    @ApiModelProperty("合作状态")
    private String cooperateStatus;
    @ApiModelProperty("kms关联客户门店id")
    private String storeId;
    @ApiModelProperty("kms直营体系id")
    private String directSystemId;
    @ApiModelProperty("kms售达方id")
    private String sellPartyId;
    @ApiModelProperty("审批类型")
    private String approvalType;
    @ApiModelProperty("流程编号")
    private String processCode;
    @ApiModelProperty("客户用户与终端关联表id")
    private String relId;

}