package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户登录日志表返回vo
 *
 * @author Tao.Chen
 * @date 2021-03-18 21:38:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户登录日志表")
@CrmColumnResolve
public class MdmUserLoginLogRespVo extends PageVo {

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("用户姓名")
    private String fullName;

    @ApiModelProperty("登录来源")
    private String fromType;

    @ApiModelProperty("登录来源")
    private String fromTypeName;

    @ApiModelProperty("登录时间 yyyy-MM-dd HH:mm:ss")
    private String loginDateTime;

    @ApiModelProperty("IP地址")
    private String clientIp;

    @ApiModelProperty("大洲(en)")
    private String clientContinentEn;

    @ApiModelProperty("大洲(zh_cn)")
    private String clientContinentZh;

    @ApiModelProperty("国家(en)")
    private String clientCountryEn;

    @ApiModelProperty("国家(zh_cn)")
    private String clientCountryZh;

    @ApiModelProperty("省份(en)")
    private String clientSubdivisionEn;

    @ApiModelProperty("省份(zh_cn)")
    private String clientSubdivisionZh;

    @ApiModelProperty("城市(en)")
    private String clientCityEn;

    @ApiModelProperty("城市(zh_cn)")
    private String clientCityZh;

    @ApiModelProperty("纬度")
    private String clientLatitude;

    @ApiModelProperty("经度")
    private String clientLongitude;

    @ApiModelProperty("服务器ip")
    private String serverIp;

    @ApiModelProperty("服务器端口号")
    private String serverPort;

    @ApiModelProperty("服务器域名")
    private String serverName;

    @ApiModelProperty("客户端地理位置")
    private String clientLocationArea;

    public String getClientLocationArea() {
        return (clientCountryZh == null ? "" : clientCountryZh) + (clientSubdivisionZh == null ? "" : clientSubdivisionZh) + (clientCityZh == null ? "" : clientCityZh);
    }
}