package com.biz.crm.nebular.rebate.expression;

import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 条件计算返回结果
 * @Author: chenrong
 * @Date: 2021/1/15 15:48
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RebateConditionComputeResult implements Serializable {

  private static final long serialVersionUID = -1016557147378443265L;

  /**
   * 计算结果
   */
  private boolean value;
  /**
   * 计算取值过程（结果）
   */
  private String computeProcess;
  /**
   * 计算取值过程（参数）
   */
  private String computeProcessResult;
  /**
   * 替换变量后的表达式
   */
  private String expressValue;
  /**
   * 原始表达式
   */
  private String expressStr;
}
