package com.biz.crm.nebular.rebate.expression;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返利公式vo
 * @Author: chenrong
 * @Date: 2021/1/11 14:57
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利公式vo")
public class RebateExpressionVo extends CrmExtTenVo {

  private static final long serialVersionUID = 2164074296725555710L;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;

  /**
   * 返利条件公式
   */
  @ApiModelProperty(value = "返利条件公式")
  private String conditionExpress;

  /**
   * 返利结果计算公式
   */
  @ApiModelProperty(value = "返利结果计算公式")
  private String computeExpress;

  /**
   * 返利政策编码
   */
  @ApiModelProperty(value = "返利政策编码")
  private String rebateCode;

  /**
   * 前端冗余字段：返利条件公式json
   */
  @ApiModelProperty(value = "返利条件公式json")
  private String conditionJson;

  /**
   * 前端冗余字段：返利计算公式json
   */
  @ApiModelProperty(value = "返利计算公式json")
  private String computeJson;

  /**
   * 序号
   */
  @ApiModelProperty(value = "序号")
  private Integer indexNo;
}
