package com.biz.crm.nebular.sfa.achievement.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 绩效规则 请求vo
 *
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAchievementRuleReqVo", description = "绩效规则")
public class SfaAchievementRuleReqVo extends CrmExtTenVo {

    /**
     * 对象集合
     */
    @ApiModelProperty("对象集合")
    private List<SfaAchievementRuleObjectReqVo> objectList;

    /**
     * 绩效时间
     */
    @ApiModelProperty("绩效时间")
    private String achievementDate;
    /**
     * 绩效时间年份
     */
    @ApiModelProperty("绩效时间年份")
    private String achievementDateYear;
    /**
     * 绩效时间月份
     */
    @ApiModelProperty("绩效时间月份")
    private String achievementDateMonth;
    /**
     * 绩效时间旬度
     */
    @ApiModelProperty("绩效时间旬度")
    private String achievementDateTenDays;

    /**
     * 开始时间（用于查询记录）
     */
    @ApiModelProperty("绩效开始时间（自由时间）")
    private String beginDate;

    /**
     * 结束时间（用于查询记录）
     */
    @ApiModelProperty("绩效结束时间（自由时间）")
    private String endDate;

    /**
     * 绩效类型
     */
    @ApiModelProperty("绩效类型")
    private String achievementType;

    /**
     * 指标集合
     */
    @ApiModelProperty("指标集合")
    private List<SfaIndexRuleReqVo> indexReqVos;

}
