package com.biz.crm.nebular.sfa.activity.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 活动执行;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaActivityExecutionReqVo", description = "活动执行;")
public class SfaActivityExecutionReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动类型(cost-费用活动,display-陈列活动,bg-方案活动)")
    private String activityType;

    @ApiModelProperty("活动状态(0-未开始,1-已开始,2-已结束)")
    private String activityStatus;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("销售额")
    private String salesVolume;

    @ApiModelProperty("申请金额")
    private String applyAmount;

    @ApiModelProperty("活动要求(0-活动照,1-门头照,2-陈列照)")
    private String activityRequire;

    @ApiModelProperty("活动描述")
    private String activityDesc;

    @ApiModelProperty("活动执行频率(天)")
    private String activityFrequency;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("活动范围列表")
    private List<SfaActivityRangeReqVo> activityRangeList;

    @ApiModelProperty("活动产品列表")
    private List<SfaActivityProductReqVo> activityProductList;

    @ApiModelProperty("示例图片地址")
    private List<SfaVisitPictureReqVo> visitPictureList;

    @ApiModelProperty("方案活动套餐列表")
    private List<SfaActivityBgSetmealReqVo> activityBgSetmealList;

}