package com.biz.crm.nebular.sfa.actscheme.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 活动方案;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaActSchemeReqVo", description = "活动方案;")
public class SfaActSchemeReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("方案名称")
    private String schemeName;

    @ApiModelProperty("方案编码")
    private String schemeCode;

    @ApiModelProperty("方案类型(1-陈列方案,2-常规促销,3-特渠促销)")
    private String schemeType;

    @ApiModelProperty("方案执行开始时间")
    private String schemeStartTime;

    @ApiModelProperty("方案执行开始时间")
    private String schemeEndTime;

    @ApiModelProperty("陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型集合")
    private List<String> displayTypeList;

    @ApiModelProperty("门店类型")
    private String terminalType;

    @ApiModelProperty("门店类型集合")
    private List<String> terminalTypeList;

    @ApiModelProperty("方案描述")
    private String schemeDesc;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("活动方案套餐列表")
    private List<SfaActSchemeSetmealReqVo> actSchemeSetmealList;

    @ApiModelProperty("活动方案文件列表")
    private List<SfaActSchemePictureReqVo> actSchemePictureList;

    @ApiModelProperty("活动方案范围列表")
    private List<SfaActSchemeRangeReqVo> actSchemeRangeList;


    @ApiModelProperty("编码集合")
    private List<String> codeList;

    @ApiModelProperty("当前时间")
    private String now;

}