package com.biz.crm.nebular.sfa.actscheme.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.sfa.actscheme.resp
 * @ClassName SfaActSchemeTerminalRespVo
 * @Author Gavin
 * @Date 2021/3/22 下午4:25
 * @Description 参与终端信息
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "参与终端信息")
@SaturnEntity(name = "SfaActSchemeTerminalRespVo", description = "参与终端信息")
public class SfaActSchemeTerminalRespVo implements Serializable {
    private static final long serialVersionUID = 7751482134651499742L;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端地址")
    private String terminalAddress;

    @ApiModelProperty("联系人姓名")
    private String contactName;
    
    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("参与描述")
    private String parDesc;
}