package com.biz.crm.nebular.sfa.asexecution.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 方案活动执行;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAsExecutionReqVo", description = "方案活动执行;")
public class SfaAsExecutionReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -904370912393208053L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("表单id")
    private String formId;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("参与类型(0_免费参与/1_协议参与)")
    private String participateInType;

    @ApiModelProperty("陈列类型")
    private String displayType;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("拜访ID")
    private String visitId;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("方案活动执行图片")
    private List<SfaAsExecutionPictureReqVo> asExecutionPictureList;

    @ApiModelProperty("方案活动执行产品数据采集")
    private List<SfaAsExecutionProductReqVo> asExecutionProductList;


}