package com.biz.crm.nebular.sfa.asexecution.req;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.sfa.asexecution.req
 * @ClassName TemplateTreatyVo
 * @Author Gavin
 * @Date 2021/3/20 下午1:45
 * @Description 模版数据
 */
@Data
public class TemplateTreatyVo implements Serializable {
    private static final long serialVersionUID = -7417848619960090694L;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端地址")
    private String terminalAddr;

    @ApiModelProperty("终端电话")
    private String terminalPhone;

    @ApiModelProperty("陈列信息")
    private String displayInfo;

    @ApiModelProperty("陈列位置")
    private String displayPlace;

    @ApiModelProperty("陈列规格")
    private String displaySpecs;

    @ApiModelProperty("陈列件数")
    private String displayNumber;

    @ApiModelProperty("陈列开始时间")
    private String displayStartTime;

    @ApiModelProperty("陈列结束时间")
    private String displayEndTime;

    @ApiModelProperty("陈列月份")
    private String displayMonth;

    @ApiModelProperty("每月支付现金")
    private BigDecimal monthPayAmount;

    @ApiModelProperty("合计奖励现金")
    private BigDecimal totalAmount;

    @ApiModelProperty("奖励收款人")
    private String payee;

    @ApiModelProperty("联系电话")
    private String contactPhone;

    @ApiModelProperty("当前操作人名称")
    private String currUserName;

    @ApiModelProperty("当前操作人电话")
    private String currUserPhone;

    @SaturnColumn(description = "备注")
    private String remarks;
}